"use server"
import outputs from '@/../amplify_outputs.json';
import { Schema } from '@/aws-data-schema';

import { generateServerClientUsingCookies } from "@aws-amplify/adapter-nextjs/api";
import { cookies } from "next/headers";
import { transformStatewideServicesResult } from './transformers';

const client = generateServerClientUsingCookies<Schema>({
  cookies: cookies,
  config: outputs
})

export const getStatewideServices = async () => {
  const res = await client.models.StatewideServices.list()
  return transformStatewideServicesResult(res)
};

export const deleteStatewideService = async (id: string) => {
  return client.models.StatewideServices.delete({
    id
  })
};

export const addStatewideService = async (service: AmplifyStatewideServicesAddProps) => {
  return client.models.StatewideServices.create(service)
};

export const updateStatewideService = async (service: AmplifyStatewideServicesUpdateProps) => {
  return client.models.StatewideServices.update(service)
};

export type AmplifyStatewideServicesListResult = Awaited<ReturnType<typeof client.models.StatewideServices.list>>
export type AmplifyStatewideServicesDeleteResult = Awaited<ReturnType<typeof client.models.StatewideServices.delete>>
export type AmplifyStatewideServicesAddResult = Awaited<ReturnType<typeof client.models.StatewideServices.create>>
export type AmplifyStatewideServicesAddProps = Parameters<typeof client.models.StatewideServices.create>["0"]
export type AmplifyStatewideServicesUpdateProps = Parameters<typeof client.models.StatewideServices.update>["0"]
